package fastfood.application;

import java.util.*;
import fastfood.domain.Product;

public class ProductSales implements Sales {
  private Date _date;
  private Product _product;

  public ProductSales(int id, Date date){
    _product = Product.$getProduct(id);
    _date = date;
  }

  protected ProductSales(Product product, Date date) {
    _product = product;
    _date = date;
  }

  public int getTotal() {
    return _product.getTotalQuantity(_date) * _product.getPrice();
  }

  public ProductFacade getProduct() {
    return  new ProductFacade(_product);
  }

  public String getName() {
    return _product.getName();
  }

  public Date getDate() {
    return _date;
  }

  public static Vector $getAllSales(Date checkDate) {
    Vector retval = new Vector();
    Iterator iter = Product.iterator();
    while (iter.hasNext()) {
      retval.add(new ProductSales((Product)iter.next(), checkDate));
    }
    return retval;
  }
}