package fastfood.domain;

import java.util.*;

public class Transaction{
  private Date _date;
  private Customer _customer;
  private Vector _lineItems;
  private static Vector $transactionList = new Vector();

  public Transaction( Date date ){
    _date = date;
    _lineItems = new Vector();
    $transactionList.add(this);
  }

  public void addLineItem( LineItem lineItem ){
    if(lineItem != null){
      _lineItems.add( lineItem );
    }
  }

  public void setCustomer( Customer customer ){
    _customer = customer;
  }

  public Date getDate(){
    return _date;
  }
  
  public Vector getLineItems(){
    return _lineItems;
  }

  public int sumSales(){
    int sales = 0;
    
    Iterator iter = _lineItems.iterator();
    while( iter.hasNext() ){
      sales += ((LineItem)iter.next()).getSales();
    }
    return sales;
  }

  public static Date $getSoldDate(LineItem lineItem){
    Iterator iter = $transactionList.iterator();
    while(iter.hasNext()){
      Transaction transaction = (Transaction)iter.next();
      if( transaction._lineItems.contains( lineItem ) ){
        return transaction._date;
      }
    }
    return null;
  }

  public static int $getSize(){
    return $transactionList.size();
  }
}