package fastfood.application;

import java.util.*;
import fastfood.domain.*;

public class CategorySales implements Sales {
  private Category _category;
  private Date _date;
  
  public CategorySales(int id, Date date) {
    _category = Category.$getCategory(id);
    _date = date;
  }
  
  private CategorySales(Category category, Date date) {
    _category = category;
    _date = date;
  }
  
  public String getName(){
    return _category.getName();
  }
  
  public int getTotal() {
    int retval = 0;
    Iterator iter = _category.getProductList().iterator();
    while (iter.hasNext()) {
      ProductSales sales = new ProductSales((Product)iter.next(), _date);
      retval += sales.getTotal();
    }
    return retval;
  }

  public static Iterator $getAllCategorySales(Date date) { 
    Vector retval = new Vector();
    Iterator iter = Category.iterator();
    while(iter.hasNext()){
      retval.add( new CategorySales((Category)iter.next(), date));
    }
    return retval.iterator();
  }
}
