/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.RemoteProtocolException;
import interbase.interclient.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class Statement
implements java.sql.Statement {
    RecvMessage prefetchedRecvMsg_ = null;
    int statementRef_ = 0;
    JDBCNet jdbcNet_;
    Connection connection_;
    ResultSet resultSet_ = null;
    Integer updateCountStack_ = null;
    ResultSet resultSetStack_ = null;
    boolean openOnClient_ = true;
    boolean openOnServer_ = false;
    int timeout_ = 0;
    int maxRows_ = 0;
    int maxFieldSize_ = 0;
    int fetchSize_ = 0;
    SQLWarning sqlWarnings_ = null;
    String cursorName_;
    boolean escapeProcessingEnabled_ = true;

    Statement(JDBCNet jDBCNet, Connection connection) {
        this.connection_ = connection;
        this.jdbcNet_ = jDBCNet;
        this.cursorName_ = "";
    }

    void checkForClosedStatement() throws SQLException {
        if (!this.openOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__statement_closed__);
        }
    }

    void checkForEmptySQL(String string) throws SQLException {
        if (string == null || "".equals(string)) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__sql_empty_or_null__);
        }
    }

    protected void finalize() throws Throwable {
        if (this.openOnServer_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
            this.resultSet_ = null;
        }
        this.updateCountStack_ = null;
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            string = escapeProcessor.doEscapeProcessing(string);
        }
        this.connection_.transactionStartedOnClient_ = true;
        this.remote_EXECUTE_QUERY_STATEMENT(string);
        this.connection_.transactionStartedOnServer_ = true;
        this.openOnServer_ = true;
        this.resultSetStack_ = null;
        return this.resultSet_;
    }

    void remote_EXECUTE_QUERY_STATEMENT(String string) throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(19);
        this.send_StatementExecuteData(messageBufferOutputStream, string);
        RecvMessage recvMessage = null;
        try {
            int n;
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.statementRef_ = recvMessage.readInt();
            if (!recvMessage.getHeaderEndOfStream()) {
                this.remote_sendPrefetch();
            }
            if ((n = recvMessage.readUnsignedShort()) == 0) {
                this.setWarning(recvMessage.get_WARNINGS());
                this.jdbcNet_.destroyRecvMessage(recvMessage);
            } else {
                this.resultSet_ = new ResultSet(this, this.jdbcNet_, recvMessage, n, true);
                this.resultSet_.cursorName_ = this.cursorName_;
                this.resultSet_.recv_ResultMetaData(recvMessage);
                this.resultSet_.numRows_ = recvMessage.readInt();
                this.resultSet_.setNumDataPositions(n);
                this.resultSet_.saveRowPosition();
            }
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.local_Close();
            }
            this.resultSet_ = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw sQLException;
        }
    }

    void remote_sendPrefetch() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(24);
        messageBufferOutputStream.writeInt(this.statementRef_);
        messageBufferOutputStream.writeInt(this.fetchSize_);
        this.jdbcNet_.sendPrefetchMessage(this, messageBufferOutputStream);
    }

    RecvMessage remote_recvPrefetch() throws SQLException {
        RecvMessage recvMessage = this.jdbcNet_.receivePrefetchMessage(this);
        if (!recvMessage.get_SUCCESS()) {
            throw recvMessage.get_EXCEPTIONS();
        }
        return recvMessage;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
            this.resultSet_ = null;
        }
        this.updateCountStack_ = null;
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            string = escapeProcessor.doEscapeProcessing(string);
        }
        this.connection_.transactionStartedOnClient_ = true;
        int n = this.remote_EXECUTE_UPDATE_STATEMENT(string);
        this.connection_.transactionStartedOnServer_ = true;
        this.openOnServer_ = false;
        this.resultSetStack_ = null;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int remote_EXECUTE_UPDATE_STATEMENT(String string) throws SQLException {
        int n;
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(20);
        this.send_StatementExecuteData(messageBufferOutputStream, string);
        RecvMessage recvMessage = null;
        try {
            try {
                recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
                if (!recvMessage.get_SUCCESS()) {
                    throw recvMessage.get_EXCEPTIONS();
                }
                this.statementRef_ = recvMessage.readInt();
                int n2 = recvMessage.readInt();
                this.setWarning(recvMessage.get_WARNINGS());
                n = n2;
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                if (this.resultSet_ != null) {
                    this.resultSet_.local_Close();
                }
                this.resultSet_ = null;
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
        return n;
    }

    public synchronized void close() throws SQLException {
        if (!this.openOnClient_) {
            return;
        }
        if (this.openOnServer_) {
            this.remote_CLOSE_STATEMENT();
        }
        this.local_Close();
    }

    void local_Close() throws SQLException {
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
        }
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.connection_.openStatements_.removeElement(this);
    }

    void remote_CLOSE_STATEMENT() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(27);
        messageBufferOutputStream.writeInt(this.statementRef_);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize_;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.checkForClosedStatement();
        this.maxFieldSize_ = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows_;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.checkForClosedStatement();
        if (n < 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__negative_max_rows__);
        }
        if (this.fetchSize_ > 0 && n < this.fetchSize_) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__fetch_size_exceeds_max_rows__);
        }
        this.maxRows_ = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkForClosedStatement();
        this.escapeProcessingEnabled_ = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout_;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.checkForClosedStatement();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__query_timeout__);
    }

    public synchronized void cancel() throws SQLException {
        this.checkForClosedStatement();
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__asynchronous_cancel__);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarnings_;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
    }

    void setWarning(SQLWarning sQLWarning) {
        if (this.sqlWarnings_ != null) {
            this.sqlWarnings_.setNextException(sQLWarning);
        } else {
            this.sqlWarnings_ = sQLWarning;
        }
    }

    public synchronized void setCursorName(String string) throws SQLException {
        this.checkForClosedStatement();
        this.cursorName_ = string == null ? "" : string;
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
            this.resultSet_ = null;
        }
        this.updateCountStack_ = null;
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            string = escapeProcessor.doEscapeProcessing(string);
        }
        this.connection_.transactionStartedOnClient_ = true;
        boolean bl = this.remote_EXECUTE_STATEMENT(string);
        this.connection_.transactionStartedOnServer_ = true;
        this.openOnServer_ = true;
        this.resultSetStack_ = this.resultSet_;
        return bl;
    }

    private boolean remote_EXECUTE_STATEMENT(String string) throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(18);
        this.send_StatementExecuteData(messageBufferOutputStream, string);
        RecvMessage recvMessage = null;
        try {
            int n;
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.statementRef_ = recvMessage.readInt();
            if (!recvMessage.getHeaderEndOfStream()) {
                this.remote_sendPrefetch();
            }
            if ((n = recvMessage.readUnsignedByte()) > 1) {
                throw new RemoteProtocolException(ErrorKey.remoteProtocol__unexpected_token_from_server_0__, 104);
            }
            if (n == 1) {
                int n2 = recvMessage.readUnsignedShort();
                this.resultSet_ = new ResultSet(this, this.jdbcNet_, recvMessage, n2, true);
                this.resultSet_.cursorName_ = this.cursorName_;
                this.resultSet_.recv_ResultMetaData(recvMessage);
                this.resultSet_.numRows_ = recvMessage.readInt();
                this.resultSet_.setNumDataPositions(n2);
                this.resultSet_.saveRowPosition();
            }
            if (n == 0) {
                this.updateCountStack_ = new Integer(recvMessage.readInt());
                this.setWarning(recvMessage.get_WARNINGS());
                this.jdbcNet_.destroyRecvMessage(recvMessage);
            }
            return this.resultSet_ != null;
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.local_Close();
            }
            this.resultSet_ = null;
            this.updateCountStack_ = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw sQLException;
        }
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        this.checkForClosedStatement();
        return this.resultSetStack_;
    }

    public int getUpdateCount() throws SQLException {
        this.checkForClosedStatement();
        if (this.updateCountStack_ == null) {
            return -1;
        }
        return this.updateCountStack_;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.checkForClosedStatement();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
        }
        this.resultSetStack_ = null;
        return false;
    }

    int estimateSendBufferSize(int n) {
        return 50 + this.cursorName_.length() + n;
    }

    void send_StatementExecuteData(MessageBufferOutputStream messageBufferOutputStream, String string) throws SQLException {
        messageBufferOutputStream.writeInt(this.statementRef_);
        messageBufferOutputStream.writeLDSQLText(this.cursorName_);
        this.connection_.send_TransactionConfigData(messageBufferOutputStream);
        messageBufferOutputStream.writeLDChars(string);
        messageBufferOutputStream.writeShort(this.timeout_);
        messageBufferOutputStream.writeShort(this.maxFieldSize_);
        messageBufferOutputStream.writeInt(this.fetchSize_);
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getFetchDirection() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkForClosedStatement();
        if (n < 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__negative_row_fetch_size__);
        }
        if (this.maxRows_ > 0 && n > this.maxRows_) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__fetch_size_exceeds_max_rows__);
        }
        this.fetchSize_ = n;
    }

    public synchronized int getFetchSize() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getResultSetType() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void addBatch(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void clearBatch() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int[] executeBatch() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        return this.connection_;
    }
}

