/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Array;
import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BugCheckException;
import interbase.interclient.CommunicationException;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.Globals;
import interbase.interclient.IBTimestamp;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.JDBCNet;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.ParameterConversionException;
import interbase.interclient.ParameterIndexOutOfBoundsException;
import interbase.interclient.ParameterMetaData;
import interbase.interclient.RecvMessage;
import interbase.interclient.RemoteProtocolException;
import interbase.interclient.ResultSet;
import interbase.interclient.Statement;
import interbase.interclient.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    String sql_;
    private boolean isEscapedProcedureCall_ = false;
    boolean sendInputs_ = false;
    int inputCols_;
    boolean[] inputNullables_;
    int[] inputTypes_;
    int[] inputPrecisions_;
    int[] inputScales_;
    int[] inputCharSets_;
    int[] inputCharLengths_;
    ArrayDescriptor[] arrayDescriptors_;
    char[] cbuf_;
    byte[] encodingBuf_;
    ParameterMetaData parameterMetaData_ = null;
    Object[] inputs_;
    private static final BigDecimal bdMaxShortValue = new BigDecimal(32767.0);
    private static final BigDecimal bdMinShortValue = new BigDecimal(-32768.0);
    private static final BigDecimal bdMaxIntValue = new BigDecimal(2.147483647E9);
    private static final BigDecimal bdMinIntValue = new BigDecimal(-2.147483648E9);
    private static final BigDecimal bdMaxFloatValue = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdMaxLongValue = new BigDecimal(9.223372036854776E18);
    private static final BigDecimal bdMinLongValue = new BigDecimal(-9.223372036854776E18);

    void local_Close() throws SQLException {
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
        }
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.connection_.openPreparedStatements_.removeElement(this);
        Globals.cache__.returnBuffer(this.encodingBuf_);
        Globals.cache__.returnCharBuffer(this.cbuf_);
    }

    PreparedStatement(JDBCNet jDBCNet, Connection connection, String string) throws SQLException {
        super(jDBCNet, connection);
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            this.sql_ = escapeProcessor.doEscapeProcessing(string);
            this.isEscapedProcedureCall_ = escapeProcessor.isEscapedProcedureCall();
        } else {
            this.sql_ = string;
        }
        this.connection_.transactionStartedOnClient_ = true;
        this.remote_PREPARE_STATEMENT();
        this.connection_.transactionStartedOnServer_ = true;
        this.openOnServer_ = true;
        this.inputs_ = new Object[this.inputCols_];
    }

    private void remote_PREPARE_STATEMENT() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(16);
        this.connection_.send_TransactionConfigData(messageBufferOutputStream);
        messageBufferOutputStream.writeLDChars(this.sql_);
        messageBufferOutputStream.writeBoolean(this.isEscapedProcedureCall_);
        RecvMessage recvMessage = null;
        try {
            try {
                recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
                if (!recvMessage.get_SUCCESS()) {
                    throw recvMessage.get_EXCEPTIONS();
                }
                this.statementRef_ = recvMessage.readInt();
                this.inputCols_ = recvMessage.readUnsignedShort();
                this.inputNullables_ = new boolean[this.inputCols_];
                this.inputTypes_ = new int[this.inputCols_];
                this.inputPrecisions_ = new int[this.inputCols_];
                this.inputScales_ = new int[this.inputCols_];
                this.inputCharSets_ = new int[this.inputCols_];
                this.inputCharLengths_ = new int[this.inputCols_];
                this.arrayDescriptors_ = new ArrayDescriptor[this.inputCols_];
                int n = 0;
                while (n < this.inputCols_) {
                    this.inputNullables_[n] = recvMessage.readBoolean();
                    this.inputTypes_[n] = recvMessage.readUnsignedByte();
                    this.inputPrecisions_[n] = recvMessage.readUnsignedShort();
                    this.inputScales_[n] = recvMessage.readUnsignedByte();
                    this.inputCharSets_[n] = recvMessage.readUnsignedShort();
                    this.inputCharLengths_[n] = recvMessage.readUnsignedShort();
                    if (this.inputTypes_[n] == 14 && recvMessage.readBoolean()) {
                        this.arrayDescriptors_[n] = new ArrayDescriptor(recvMessage);
                    }
                    ++n;
                }
                this.allocateEncodingBufs();
                int n2 = recvMessage.readUnsignedByte();
                if (n2 > 1) {
                    throw new RemoteProtocolException(ErrorKey.remoteProtocol__unexpected_token_from_server_0__, 105);
                }
                if (n2 == 0) {
                    this.setWarning(recvMessage.get_WARNINGS());
                }
                if (n2 == 1) {
                    int n3 = recvMessage.readUnsignedShort();
                    if (n3 == 0) {
                        throw new BugCheckException(ErrorKey.bugCheck__0__, 111);
                    }
                    this.resultSet_ = new ResultSet(this, this.jdbcNet_, null, n3, false);
                    this.resultSet_.recv_ResultMetaData(recvMessage);
                    this.setWarning(recvMessage.get_WARNINGS());
                }
                if (n2 < 0) {
                    throw new BugCheckException(ErrorKey.bugCheck__0__, 112);
                }
                Object var7_7 = null;
            }
            catch (SQLException sQLException) {
                if (this.resultSet_ != null) {
                    this.resultSet_.local_Close();
                    this.resultSet_ = null;
                }
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    synchronized void allocateEncodingBufs() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.inputCols_) {
            if (this.inputPrecisions_[n3] > n) {
                n = this.inputPrecisions_[n3];
            }
            if (this.inputCharLengths_[n3] > n2) {
                n2 = this.inputCharLengths_[n3];
            }
            ++n3;
        }
        this.encodingBuf_ = Globals.cache__.takeBuffer(n + 1);
        this.cbuf_ = Globals.cache__.takeCharBuffer(n2);
    }

    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (!this.allNonNullablesAreSet()) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__parameter_not_set__);
        }
        if (this.resultSet_ == null) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__execute_query_on_an_update_statement__);
        }
        this.resultSet_.cursorName_ = this.cursorName_;
        if (this.resultSet_.openOnServer_) {
            this.resultSet_.local_Close();
        }
        this.updateCountStack_ = null;
        this.connection_.transactionStartedOnClient_ = true;
        this.remote_EXECUTE_PREPARED_QUERY_STATEMENT();
        this.connection_.transactionStartedOnServer_ = true;
        this.resultSetStack_ = null;
        return this.resultSet_;
    }

    private void remote_EXECUTE_PREPARED_QUERY_STATEMENT() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(22);
        this.send_PreparedStatementExecuteData(messageBufferOutputStream);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            if (!recvMessage.getHeaderEndOfStream()) {
                this.remote_sendPrefetch();
            }
            this.resultSet_.local_open();
            this.resultSet_.numRows_ = recvMessage.readInt();
            this.resultSet_.setRecvBuffer(recvMessage);
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.local_Close();
            }
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw sQLException;
        }
    }

    public synchronized int executeUpdate() throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (!this.allNonNullablesAreSet()) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__parameter_not_set__);
        }
        if (this.resultSet_ != null && this.resultSet_.openOnServer_) {
            this.resultSet_.local_Close();
        }
        this.updateCountStack_ = null;
        this.connection_.transactionStartedOnClient_ = true;
        int n = this.remote_EXECUTE_PREPARED_UPDATE_STATEMENT();
        this.connection_.transactionStartedOnServer_ = true;
        this.resultSetStack_ = null;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int remote_EXECUTE_PREPARED_UPDATE_STATEMENT() throws SQLException {
        int n;
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(23);
        this.send_PreparedStatementExecuteData(messageBufferOutputStream);
        RecvMessage recvMessage = null;
        try {
            try {
                recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
                if (!recvMessage.get_SUCCESS()) {
                    throw recvMessage.get_EXCEPTIONS();
                }
                int n2 = recvMessage.readInt();
                this.setWarning(recvMessage.get_WARNINGS());
                n = n2;
                Object var6_6 = null;
            }
            catch (SQLException sQLException) {
                if (this.resultSet_ == null) throw sQLException;
                this.resultSet_.local_Close();
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
        return n;
    }

    private boolean allNonNullablesAreSet() {
        int n = 0;
        while (n < this.inputCols_) {
            if (!this.inputNullables_[n] && this.inputs_[n] == null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.checkForClosedStatement();
        try {
            if (!this.inputNullables_[n - 1]) {
                throw new InvalidOperationException(ErrorKey.invalidOperation__set_null_on_non_nullable_parameter__);
            }
            this.inputs_[n - 1] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    private int getParameterIBType(int n) throws SQLException {
        try {
            return this.inputTypes_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        if (bl) {
            this.setInt(n, 1);
        } else {
            this.setInt(n, 0);
        }
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.setInt(n, by);
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.setInt(n, s);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.checkForClosedStatement();
        int n3 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n3) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal = new BigDecimal((double)n2);
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n3) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 1: {
                if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Short((short)n2);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                this.inputs_[n - 1] = new Integer(n2);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(n2);
                break;
            }
            case 3: {
                this.inputs_[n - 1] = new Float(n2);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(n2);
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, String.valueOf(n2)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal = new BigDecimal((double)l);
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 1: {
                if (l > 32767L || l < -32768L) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Short((short)l);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Integer((int)l);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(l);
                break;
            }
            case 3: {
                this.inputs_[n - 1] = new Float(l);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(l);
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, String.valueOf(l)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal = new BigDecimal(f);
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 1: {
                if (f > 32767.0f || f < -32768.0f) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Short((short)f);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                if (f > 2.1474836E9f || f < -2.1474836E9f) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Integer((int)f);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(f);
                break;
            }
            case 3: {
                this.inputs_[n - 1] = new Float(f);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(f);
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, String.valueOf(f)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal = new BigDecimal(d);
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 1: {
                if (d > 32767.0 || d < -32768.0) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Short((short)d);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Integer((int)d);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(d);
                break;
            }
            case 3: {
                if (d > 3.4028234663852886E38 || d < (double)1.4E-45f) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Float((float)d);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(d);
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, String.valueOf(d)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal2 = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal2 = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal2 = bigDecimal2.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal2.compareTo(bdMaxShortValue) == 1 || bigDecimal2.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Short(bigDecimal2.shortValue());
                break;
            }
            case 1: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal2.compareTo(bdMaxIntValue) == 1 || bigDecimal2.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal2.intValue());
                break;
            }
            case 2: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal2.compareTo(bdMaxLongValue) == 1 || bigDecimal2.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Long(bigDecimal2.longValue());
                break;
            }
            case 4: 
            case 5: {
                if (bigDecimal.compareTo(bdMaxDoubleValue) == 1 || bigDecimal.compareTo(bdMinDoubleValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Double(bigDecimal.doubleValue());
                break;
            }
            case 3: {
                if (bigDecimal.compareTo(bdMaxFloatValue) == 1 || bigDecimal.compareTo(bdMinFloatValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Float(bigDecimal.floatValue());
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = bigDecimal.toString();
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, bigDecimal.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        try {
            switch (n2) {
                case 1: 
                case 2: {
                    this.setInt(n, Integer.parseInt(string));
                    break;
                }
                case 6: 
                case 7: {
                    this.setBigDecimal(n, new BigDecimal(string));
                    break;
                }
                case 4: 
                case 5: {
                    this.inputs_[n - 1] = new Double(string);
                    break;
                }
                case 3: {
                    this.inputs_[n - 1] = new Float(string);
                    break;
                }
                case 8: 
                case 9: {
                    this.inputs_[n - 1] = string;
                    if (string.length() <= this.inputCharLengths_[n - 1]) break;
                    throw new DataTruncation(n, true, false, string.length(), this.inputCharLengths_[n - 1]);
                }
                case 14: {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
                }
                case 10: 
                case 12: {
                    this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, string));
                    break;
                }
                case 11: {
                    try {
                        this.setTimestamp(n, Timestamp.valueOf(string));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
                    }
                }
                case 17: 
                case 18: 
                case 19: {
                    this.setBigDecimal(n, new BigDecimal(string));
                    break;
                }
                case 15: {
                    try {
                        this.setDate(n, Date.valueOf(string));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
                    }
                }
                case 16: {
                    try {
                        this.setTime(n, Time.valueOf(string));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
        }
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = byArray;
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobBinaryStream(this, new ByteArrayInputStream(byArray), byArray.length));
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = date.toString();
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, date.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_date_on_binary_blob__);
            }
            case 11: 
            case 15: {
                this.inputs_[n - 1] = new IBTimestamp(date.getYear(), date.getMonth(), date.getDate());
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = time.toString();
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, time.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_date_on_binary_blob__);
            }
            case 11: 
            case 16: {
                this.inputs_[n - 1] = new IBTimestamp(0, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = timestamp.toString();
                break;
            }
            case 10: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobString(this, timestamp.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_date_on_binary_blob__);
            }
            case 11: {
                this.inputs_[n - 1] = new IBTimestamp(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                break;
            }
            case 15: {
                this.inputs_[n - 1] = new IBTimestamp(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate(), 0, 0, 0);
                break;
            }
            case 16: {
                this.inputs_[n - 1] = new IBTimestamp(0, 0, 1, timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    byte[] getBytesFromInputStream(InputStream inputStream, int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                n2 += inputStream.read(byArray, n2, n - n2);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__user_stream__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    String getStringFromAsciiInputStream(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = this.getBytesFromInputStream(inputStream, n);
        return new String(byArray, 0);
    }

    String getStringFromUnicodeInputStream(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = this.getBytesFromInputStream(inputStream, n);
        char[] cArray = new char[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n / 2) {
            int n4 = (byArray[n2++] & 0xFF) << 8;
            int n5 = (byArray[n2++] & 0xFF) << 0;
            cArray[n3] = (char)(n4 + n5);
            ++n3;
        }
        return new String(cArray);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkForClosedStatement();
        int n3 = this.getParameterIBType(n);
        switch (n3) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = this.getStringFromAsciiInputStream(inputStream, n2);
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobBinaryStream(this, inputStream, n2));
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkForClosedStatement();
        int n3 = this.getParameterIBType(n);
        if (n2 % 2 != 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__setUnicodeStream_odd_bytes__);
        }
        switch (n3) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = this.getStringFromUnicodeInputStream(inputStream, n2);
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobUnicodeStream(this, inputStream, n2));
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkForClosedStatement();
        int n3 = this.getParameterIBType(n);
        switch (n3) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = this.getBytesFromInputStream(inputStream, n2);
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Integer(this.jdbcNet_.setBlobBinaryStream(this, inputStream, n2));
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
    }

    public synchronized void clearParameters() throws SQLException {
        this.checkForClosedStatement();
        int n = 0;
        while (n < this.inputCols_) {
            this.inputs_[n] = null;
            ++n;
        }
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof byte[] && this.getParameterIBType(n) != 14) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof java.sql.Array) {
            this.setArray(n, (java.sql.Array)object);
        } else if (object.getClass().isArray()) {
            this.setJavaArray(n, object);
        } else {
            if (object instanceof InputStream) {
                throw new ParameterConversionException(ErrorKey.parameterConversion__set_object_on_stream__);
            }
            throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
        }
    }

    public synchronized boolean execute() throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (!this.allNonNullablesAreSet()) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__parameter_not_set__);
        }
        if (this.resultSet_ != null) {
            this.resultSet_.cursorName_ = this.cursorName_;
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.local_Close();
            }
        }
        this.updateCountStack_ = null;
        this.connection_.transactionStartedOnClient_ = true;
        this.remote_EXECUTE_PREPARED_STATEMENT();
        this.connection_.transactionStartedOnServer_ = true;
        this.resultSetStack_ = this.resultSet_;
        return this.resultSet_ != null;
    }

    private void remote_EXECUTE_PREPARED_STATEMENT() throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(21);
        this.send_PreparedStatementExecuteData(messageBufferOutputStream);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            if (!recvMessage.getHeaderEndOfStream()) {
                this.remote_sendPrefetch();
            }
            if (this.resultSet_ == null) {
                this.updateCountStack_ = new Integer(recvMessage.readInt());
                this.setWarning(recvMessage.get_WARNINGS());
                this.jdbcNet_.destroyRecvMessage(recvMessage);
            } else {
                this.resultSet_.local_open();
                this.resultSet_.numRows_ = recvMessage.readInt();
                this.resultSet_.setRecvBuffer(recvMessage);
            }
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.local_Close();
            }
            this.updateCountStack_ = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw sQLException;
        }
    }

    private void send_PreparedStatementExecuteData(MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        messageBufferOutputStream.writeInt(this.statementRef_);
        messageBufferOutputStream.writeLDSQLText(this.cursorName_);
        this.connection_.send_TransactionConfigData(messageBufferOutputStream);
        messageBufferOutputStream.writeShort(this.timeout_);
        messageBufferOutputStream.writeShort(this.maxFieldSize_);
        messageBufferOutputStream.writeInt(this.fetchSize_);
        int n = 0;
        while (n < this.inputCols_) {
            this.send_Data(n, messageBufferOutputStream);
            ++n;
        }
    }

    private void send_Data(int n, MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        int n2;
        if (this.inputNullables_[n]) {
            n2 = this.inputs_[n] == null ? 1 : 0;
            messageBufferOutputStream.writeBoolean(n2 != 0);
            if (n2 != 0) {
                return;
            }
        }
        switch (this.inputTypes_[n]) {
            case 1: {
                messageBufferOutputStream.writeShort(((Short)this.inputs_[n]).intValue());
                break;
            }
            case 2: {
                messageBufferOutputStream.writeInt((Integer)this.inputs_[n]);
                break;
            }
            case 3: {
                messageBufferOutputStream.writeFloat(((Float)this.inputs_[n]).floatValue());
                break;
            }
            case 4: {
                messageBufferOutputStream.writeDouble((Double)this.inputs_[n]);
                break;
            }
            case 5: {
                messageBufferOutputStream.writeDouble((Double)this.inputs_[n]);
                messageBufferOutputStream.writeByte(this.inputScales_[n]);
                break;
            }
            case 6: {
                messageBufferOutputStream.writeInt((Integer)this.inputs_[n]);
                messageBufferOutputStream.writeByte(this.inputScales_[n]);
                break;
            }
            case 7: {
                messageBufferOutputStream.writeShort(((Short)this.inputs_[n]).intValue());
                messageBufferOutputStream.writeByte(this.inputScales_[n]);
                break;
            }
            case 8: 
            case 9: {
                if (this.inputs_[n] instanceof String) {
                    messageBufferOutputStream.writeLDChars((String)this.inputs_[n], this.cbuf_, this.encodingBuf_);
                    break;
                }
                messageBufferOutputStream.writeLDBytes((byte[])this.inputs_[n]);
                break;
            }
            case 17: 
            case 18: {
                messageBufferOutputStream.writeLong((Long)this.inputs_[n]);
                messageBufferOutputStream.writeByte(this.inputScales_[n]);
                break;
            }
            case 19: {
                messageBufferOutputStream.writeInt((Integer)this.inputs_[n]);
                messageBufferOutputStream.writeByte(this.inputScales_[n]);
                break;
            }
            case 15: {
                messageBufferOutputStream.writeInt(((IBTimestamp)this.inputs_[n]).encodedYearMonthDay_);
                break;
            }
            case 16: {
                messageBufferOutputStream.writeInt(((IBTimestamp)this.inputs_[n]).encodedHourMinuteSecond_);
                break;
            }
            case 11: {
                messageBufferOutputStream.writeInt(((IBTimestamp)this.inputs_[n]).encodedYearMonthDay_);
                messageBufferOutputStream.writeInt(((IBTimestamp)this.inputs_[n]).encodedHourMinuteSecond_);
                break;
            }
            case 14: {
                ((Array)this.inputs_[n]).send(messageBufferOutputStream);
                break;
            }
            case 10: 
            case 12: {
                n2 = (Integer)this.inputs_[n];
                messageBufferOutputStream.writeInt(n2);
                break;
            }
            default: {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 113);
            }
        }
    }

    private void remote_GET_ARRAY_DESCRIPTOR(int n, String string, String string2) throws SQLException {
        MessageBufferOutputStream messageBufferOutputStream = this.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(38);
        this.connection_.send_TransactionConfigData(messageBufferOutputStream);
        messageBufferOutputStream.writeLDChars(string);
        messageBufferOutputStream.writeLDChars(string2);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            if (recvMessage.readBoolean()) {
                this.arrayDescriptors_[n] = new ArrayDescriptor(recvMessage);
            }
            this.setWarning(recvMessage.get_WARNINGS());
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.jdbcNet_.destroyRecvMessage(recvMessage);
    }

    public synchronized void addBatch() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setArray(int n, java.sql.Array array) throws SQLException {
        this.setJavaArray(n, array.getArray());
    }

    private synchronized void setJavaArray(int n, Object object) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        if (n2 == 14) {
            if (this.arrayDescriptors_[n - 1] == null) {
                throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
            }
        } else {
            throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
        }
        Array array = new Array(object);
        array.setDescriptor(this.arrayDescriptors_[n - 1]);
        this.inputs_[n - 1] = array;
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkForClosedStatement();
        return this.resultSet_.getMetaData();
    }

    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkForClosedStatement();
        if (this.parameterMetaData_ == null) {
            this.parameterMetaData_ = new ParameterMetaData(this);
        }
        return this.parameterMetaData_;
    }

    public synchronized ResultSetMetaData getResultSetMetaData() throws SQLException {
        return this.getMetaData();
    }

    public synchronized void prepareArray(int n, String string, String string2) throws SQLException {
        if (this.getParameterIBType(n) != 14) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__not_array_parameter__);
        }
        if (this.arrayDescriptors_[n - 1] != null) {
            return;
        }
        this.checkForClosedStatement();
        this.clearWarnings();
        this.connection_.transactionStartedOnClient_ = true;
        this.remote_GET_ARRAY_DESCRIPTOR(n - 1, string, string2);
        this.connection_.transactionStartedOnServer_ = true;
    }
}

