/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BadInstallationException;
import interbase.interclient.BlobInput;
import interbase.interclient.BlobOutput;
import interbase.interclient.BugCheckException;
import interbase.interclient.CommunicationException;
import interbase.interclient.Crypter;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.RecvMessage;
import interbase.interclient.RemoteProtocolException;
import interbase.interclient.ServerVersionInformation;
import interbase.interclient.SocketTimeoutException;
import interbase.interclient.Statement;
import interbase.interclient.UnknownHostException;
import interbase.interclient.Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Vector;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

final class JDBCNet {
    private static final int blobPutSegmentSize__ = 30720;
    private static final int inputStreamBufferSize__ = 10240;
    private Socket socket_;
    String server_;
    int socketTimeout_;
    InputStream inputStream_;
    private OutputStream outputStream_;
    private BlobOutput activeBlobOutputOnWire_;
    private RecvMessage activeRecvMsgOnWire_;
    private boolean streamedMessages_ = false;
    private boolean byteswap_;
    private Vector prefetchRequestors_ = new Vector(12, 12);
    Crypter crypter_;
    private int interserverRemoteProtocolVersion_;
    private int interserverMessageCertificate_;
    ServerVersionInformation serverVersionInformation_;
    private ByteToCharConverter btc_;
    private CharToByteConverter ctb_;

    JDBCNet(int n, String string, int n2, ByteToCharConverter byteToCharConverter, CharToByteConverter charToByteConverter) throws SQLException {
        this.server_ = string;
        this.btc_ = byteToCharConverter;
        this.ctb_ = charToByteConverter;
        this.establishSocketStreams(n, n2, string);
        this.establishProtocol();
        Globals.cache__.incrementConnectionCount();
    }

    private synchronized void establishSocketStreams(int n, int n2, String string) throws SQLException {
        try {
            this.socket_ = new Socket(string, n2);
            this.socket_.setTcpNoDelay(true);
            this.socket_.setSoTimeout(n);
            this.inputStream_ = new BufferedInputStream(this.socket_.getInputStream(), 10240);
            this.outputStream_ = this.socket_.getOutputStream();
        }
        catch (SocketException socketException) {
            throw new CommunicationException(ErrorKey.communication__socket_exception_on_connect_01__, string, Utils.getMessage(socketException));
        }
        catch (java.net.UnknownHostException unknownHostException) {
            throw new UnknownHostException(ErrorKey.unknownHost__0__, string);
        }
        catch (IOException iOException) {
            if (this.socket_ != null) {
                try {
                    this.socket_.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            throw new CommunicationException(ErrorKey.communication__io_exception_on_connect_01__, string, Utils.getMessage(iOException));
        }
        catch (SecurityException securityException) {
            throw new BadInstallationException(ErrorKey.badInstallation__security_check_on_socket_01__, new Object[]{string, Utils.getMessage(securityException)});
        }
    }

    synchronized void disconnectSocket() throws SQLException {
        Globals.cache__.decrementConnectionCount();
        try {
            this.socket_.close();
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_disconnect_01__, this.server_, Utils.getMessage(iOException));
        }
    }

    private void establishProtocol() throws SQLException {
        RecvMessage recvMessage = this.receiveProtocolMessage();
        try {
            if (recvMessage.readUnsignedByte() != 1) {
                throw new RemoteProtocolException(ErrorKey.remoteProtocol__unable_to_establish_protocol__);
            }
            int n = recvMessage.readInt();
            this.crypter_ = new Crypter(n);
            this.serverVersionInformation_ = new ServerVersionInformation();
            this.serverVersionInformation_.jdbcNetProtocolVersion_ = this.interserverRemoteProtocolVersion_;
            this.interserverMessageCertificate_ = recvMessage.readInt();
            this.serverVersionInformation_.majorVersion_ = recvMessage.readInt();
            this.serverVersionInformation_.minorVersion_ = recvMessage.readInt();
            this.serverVersionInformation_.buildNumber_ = recvMessage.readInt();
            this.serverVersionInformation_.buildLevel_ = recvMessage.readInt();
            int n2 = recvMessage.readInt();
            int n3 = recvMessage.readInt();
            int n4 = recvMessage.readInt();
            if (n4 == 0) {
                this.serverVersionInformation_.expirationDate_ = null;
            } else {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(1900 + n2, n3, n4);
                this.serverVersionInformation_.expirationDate_ = gregorianCalendar.getTime();
            }
            this.serverVersionInformation_.name_ = recvMessage.readLDSQLText();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.destroyRecvMessage(recvMessage);
    }

    private synchronized RecvMessage receiveProtocolMessage() throws SQLException {
        try {
            this.interserverRemoteProtocolVersion_ = this.readJavaInt();
            if (this.interserverRemoteProtocolVersion_ != 20001) {
                throw new BadInstallationException(ErrorKey.badInstallation__incompatible_remote_protocols__);
            }
            int n = this.readJavaInt();
            this.readJavaInt();
            this.byteswap_ = this.readJavaInt() != 0;
            RecvMessage recvMessage = new RecvMessage(n, this.inputStream_, this.byteswap_, 0, 0, this.btc_);
            recvMessage.bufferOut();
            return recvMessage;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new SocketTimeoutException(ErrorKey.socketTimeout__012__, new Object[]{this.server_, String.valueOf(this.socketTimeout_), Utils.getMessage(interruptedIOException)});
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_recv_protocol_01__, this.server_, Utils.getMessage(iOException));
        }
    }

    private synchronized RecvMessage receiveMessage() throws SQLException {
        try {
            if (this.readNativeInt() != this.interserverMessageCertificate_) {
                throw new RemoteProtocolException(ErrorKey.remoteProtocol__bad_message_certficate_from_server__);
            }
            int n = this.readNativeInt();
            int n2 = this.readNativeInt();
            int n3 = this.readNativeInt();
            RecvMessage recvMessage = new RecvMessage(n, this.inputStream_, this.byteswap_, n2, n3, this.btc_);
            if (this.streamedMessages_) {
                this.activeRecvMsgOnWire_ = recvMessage;
            } else {
                recvMessage.bufferOut();
            }
            return recvMessage;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new SocketTimeoutException(ErrorKey.socketTimeout__012__, new Object[]{this.server_, String.valueOf(this.socketTimeout_), Utils.getMessage(interruptedIOException)});
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_recv_message_01__, this.server_, Utils.getMessage(iOException));
        }
    }

    synchronized RecvMessage receivePrefetchMessage(Statement statement) throws SQLException {
        if (statement.prefetchedRecvMsg_ != null) {
            RecvMessage recvMessage = statement.prefetchedRecvMsg_;
            statement.prefetchedRecvMsg_ = null;
            return recvMessage;
        }
        if (this.activeBlobOutputOnWire_ != null) {
            this.activeBlobOutputOnWire_.close();
            this.activeRecvMsgOnWire_ = null;
        } else if (this.activeRecvMsgOnWire_ != null) {
            this.activeRecvMsgOnWire_.bufferOut();
            this.activeRecvMsgOnWire_ = null;
        }
        while (!this.prefetchRequestors_.isEmpty()) {
            Statement statement2 = (Statement)this.prefetchRequestors_.firstElement();
            this.prefetchRequestors_.removeElementAt(0);
            RecvMessage recvMessage = this.receiveMessage();
            if (statement == statement2) {
                if (this.streamedMessages_) {
                    this.activeRecvMsgOnWire_ = recvMessage;
                } else {
                    recvMessage.bufferOut();
                }
                return recvMessage;
            }
            recvMessage.bufferOut();
            statement2.prefetchedRecvMsg_ = recvMessage;
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 100);
    }

    synchronized void destroyRecvMessage(RecvMessage recvMessage) throws SQLException {
        if (recvMessage == this.activeRecvMsgOnWire_) {
            this.activeRecvMsgOnWire_ = null;
        }
        if (recvMessage != null) {
            recvMessage.destroy();
        }
    }

    MessageBufferOutputStream createMessage() {
        MessageBufferOutputStream messageBufferOutputStream = Globals.cache__.takeOutputBuffer();
        messageBufferOutputStream.setConverter(this.ctb_);
        return messageBufferOutputStream;
    }

    void sendMessage(MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        try {
            OutputStream outputStream = this.outputStream_;
            synchronized (outputStream) {
                messageBufferOutputStream.writeFirstInt(this.interserverMessageCertificate_);
                messageBufferOutputStream.writeSecondInt(messageBufferOutputStream.messageSize());
                messageBufferOutputStream.writeTo(this.outputStream_);
            }
            this.outputStream_.flush();
            Globals.cache__.returnOutputBuffer(messageBufferOutputStream);
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_send_message_01__, this.server_, Utils.getMessage(iOException));
        }
    }

    synchronized void sendPrefetchMessage(Statement statement, MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        this.prefetchRequestors_.addElement(statement);
        this.sendMessage(messageBufferOutputStream);
    }

    synchronized RecvMessage sendAndReceiveMessage(MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        this.sendMessage(messageBufferOutputStream);
        this.clearAllPendingMessages();
        return this.receiveMessage();
    }

    private void clearAllPendingMessages() throws SQLException {
        if (this.activeBlobOutputOnWire_ != null) {
            this.activeBlobOutputOnWire_.close();
            this.activeBlobOutputOnWire_ = null;
        } else if (this.activeRecvMsgOnWire_ != null) {
            this.activeRecvMsgOnWire_.bufferOut();
            this.activeRecvMsgOnWire_ = null;
        }
        while (!this.prefetchRequestors_.isEmpty()) {
            Statement statement = (Statement)this.prefetchRequestors_.firstElement();
            this.prefetchRequestors_.removeElementAt(0);
            RecvMessage recvMessage = this.receiveMessage();
            recvMessage.bufferOut();
            statement.prefetchedRecvMsg_ = recvMessage;
        }
    }

    synchronized RecvMessage sendAndReceiveBlobMessage(MessageBufferOutputStream messageBufferOutputStream, BlobOutput blobOutput) throws SQLException {
        this.sendMessage(messageBufferOutputStream);
        this.clearAllPendingMessages();
        this.activeBlobOutputOnWire_ = blobOutput;
        return this.receiveMessage();
    }

    synchronized void sendPrefetchBlobMessage(MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        this.sendMessage(messageBufferOutputStream);
    }

    synchronized RecvMessage receivePrefetchBlobMessage() throws SQLException {
        return this.receiveMessage();
    }

    private int readJavaInt() throws IOException {
        int n = 0;
        int n2 = this.inputStream_.read();
        n += n2 & 0xFF;
        n2 = this.inputStream_.read();
        n += (n2 & 0xFF) << 8;
        n2 = this.inputStream_.read();
        n += (n2 & 0xFF) << 16;
        n2 = this.inputStream_.read();
        return n += (n2 & 0xFF) << 24;
    }

    int readNativeInt() throws IOException {
        int n = 0;
        if (this.byteswap_) {
            int n2 = this.inputStream_.read();
            n += n2 & 0xFF;
            n2 = this.inputStream_.read();
            n += (n2 & 0xFF) << 8;
            n2 = this.inputStream_.read();
            n += (n2 & 0xFF) << 16;
            n2 = this.inputStream_.read();
            n += (n2 & 0xFF) << 24;
        } else {
            int n3 = this.inputStream_.read();
            n += (n3 & 0xFF) << 24;
            n3 = this.inputStream_.read();
            n += (n3 & 0xFF) << 16;
            n3 = this.inputStream_.read();
            n += (n3 & 0xFF) << 8;
            n3 = this.inputStream_.read();
            n += n3 & 0xFF;
        }
        return n;
    }

    synchronized RecvMessage sendStreamAndReceiveMessage(MessageBufferOutputStream messageBufferOutputStream, InputStream inputStream, int n) throws SQLException {
        this.sendMessageWithByteStream(messageBufferOutputStream, inputStream, n);
        return this.receiveMessage();
    }

    synchronized RecvMessage sendUnicodeStreamAndReceiveMessage(MessageBufferOutputStream messageBufferOutputStream, InputStream inputStream, int n) throws SQLException {
        this.sendMessageWithUnicodeStream(messageBufferOutputStream, inputStream, n);
        return this.receiveMessage();
    }

    private void sendMessageWithByteStream(MessageBufferOutputStream messageBufferOutputStream, InputStream inputStream, int n) throws SQLException {
        OutputStream outputStream = this.outputStream_;
        synchronized (outputStream) {
            this.sendMessage(messageBufferOutputStream);
            this.writeBytes(inputStream, n);
        }
    }

    private void sendMessageWithUnicodeStream(MessageBufferOutputStream messageBufferOutputStream, InputStream inputStream, int n) throws SQLException {
        OutputStream outputStream = this.outputStream_;
        synchronized (outputStream) {
            this.sendMessage(messageBufferOutputStream);
            this.writeUnicodeToBytes(inputStream, n);
        }
    }

    void writeBytes(InputStream inputStream, int n) throws SQLException {
        if (n == 0) {
            return;
        }
        int n2 = Math.min(30720, n);
        byte[] byArray = Globals.cache__.takeBuffer(n2);
        int n3 = 0;
        try {
            try {
                while (n3 < n) {
                    int n4 = Math.min(n2, n - n3);
                    int n5 = inputStream.read(byArray, 0, n4);
                    if (n5 == -1) {
                        throw new CommunicationException(ErrorKey.communication__user_stream__unexpected_eof__);
                    }
                    this.outputStream_.write(byArray, 0, n5);
                    n3 += n5;
                    this.outputStream_.flush();
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__user_stream__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            Object var10_8 = null;
            Globals.cache__.returnBuffer(byArray);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Globals.cache__.returnBuffer(byArray);
            throw throwable;
        }
    }

    void writeUnicodeToBytes(InputStream inputStream, int n) throws SQLException {
        if (n == 0) {
            return;
        }
        if (n % 2 != 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__setUnicodeStream_odd_bytes__);
        }
        int n2 = Math.min(30720, n / 2 * 3);
        int n3 = n2 / 3;
        int n4 = 0;
        byte[] byArray = Globals.cache__.takeBuffer(n2);
        byte[] byArray2 = Globals.cache__.takeBuffer(2 * n3);
        char[] cArray = Globals.cache__.takeCharBuffer(n3);
        try {
            try {
                while (n4 < n) {
                    int n5;
                    int n6;
                    int n7 = Math.min(2 * n3, n - n4);
                    int n8 = 0;
                    while (n8 < n7) {
                        n6 = inputStream.read(byArray2, 0 + n8, n7 - n8);
                        if (n6 == -1) {
                            throw new CommunicationException(ErrorKey.communication__user_stream__unexpected_eof__);
                        }
                        n8 += n6;
                    }
                    n6 = 0;
                    int n9 = n8 / 2;
                    int n10 = 0;
                    while (n10 < n9) {
                        n5 = (byArray2[n6++] & 0xFF) << 8;
                        int n11 = (byArray2[n6++] & 0xFF) << 0;
                        cArray[n10] = (char)(n5 + n11);
                        ++n10;
                    }
                    n5 = this.ctb_.convert(cArray, 0, n9, byArray, 0, byArray.length);
                    this.outputStream_.write(byArray, 0, n5);
                    n4 += n8;
                    this.outputStream_.flush();
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__user_stream__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            Object var17_17 = null;
            Globals.cache__.returnBuffer(byArray);
            Globals.cache__.returnCharBuffer(cArray);
            Globals.cache__.returnBuffer(byArray2);
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Globals.cache__.returnBuffer(byArray);
            Globals.cache__.returnCharBuffer(cArray);
            Globals.cache__.returnBuffer(byArray2);
            throw throwable;
        }
    }

    BlobOutput openBlobOutput(Statement statement, int[] nArray) throws SQLException {
        return new BlobOutput(this, statement, nArray, this.btc_);
    }

    int setBlobBinaryStream(Statement statement, InputStream inputStream, int n) throws SQLException {
        return new BlobInput((JDBCNet)this, (Statement)statement, (int)0, (InputStream)inputStream, (int)n).a1;
    }

    int setBlobUnicodeStream(Statement statement, InputStream inputStream, int n) throws SQLException {
        return new BlobInput((JDBCNet)this, (Statement)statement, (int)1, (InputStream)inputStream, (int)n).a1;
    }

    int setBlobString(Statement statement, String string) throws SQLException {
        try {
            byte[] byArray = string.getBytes(this.ctb_.getCharacterEncoding());
            return new BlobInput((JDBCNet)this, (Statement)statement, (int)0, (InputStream)new ByteArrayInputStream((byte[])byArray), (int)byArray.length).a1;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 128);
        }
    }
}

