/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BugCheckException;
import interbase.interclient.ErrorKey;

final class IBTimestamp {
    int encodedYearMonthDay_ = 0;
    int encodedHourMinuteSecond_ = 0;
    private int year_;
    private int month_;
    private int date_;
    private int hour_;
    private int minute_;
    private int second_;
    private static final int PRECISION__ = 10000;
    private static final int TIME_ZONE__ = 0;
    static final int DATE = 0;
    static final int TIME = 1;
    static final int DATETIME = 2;

    IBTimestamp(int n, int[] nArray) throws BugCheckException {
        this.setTimestampId(n, nArray);
    }

    IBTimestamp(int n, int n2) throws BugCheckException {
        this.setDateTime(n, n2);
    }

    void setDateTime(int n, int n2) throws BugCheckException {
        switch (n) {
            case 0: {
                this.encodedYearMonthDay_ = n2;
                this.decodeYearMonthDay();
                break;
            }
            case 1: {
                this.encodedHourMinuteSecond_ = n2;
                this.decodeHourMinuteSecond();
                break;
            }
            default: {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 116);
            }
        }
    }

    void setTimestampId(int n, int[] nArray) throws BugCheckException {
        switch (n) {
            case 2: {
                this.encodedYearMonthDay_ = nArray[0];
                this.encodedHourMinuteSecond_ = nArray[1];
                this.decodeYearMonthDay();
                this.decodeHourMinuteSecond();
                break;
            }
            case 0: {
                this.encodedYearMonthDay_ = nArray[0];
                this.decodeYearMonthDay();
                break;
            }
            case 1: {
                this.encodedHourMinuteSecond_ = nArray[1];
                this.decodeHourMinuteSecond();
                break;
            }
            default: {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 116);
            }
        }
    }

    IBTimestamp(int n, int n2, int n3) {
        this.year_ = n;
        this.month_ = n2;
        this.date_ = n3;
        this.encodeYearMonthDay();
    }

    IBTimestamp(int n, int n2, int n3, int n4, int n5) {
        this.year_ = n;
        this.month_ = n2;
        this.date_ = n3;
        this.hour_ = n4;
        this.minute_ = n5;
        this.second_ = 0;
        this.encodeYearMonthDay();
        this.encodeHourMinuteSecond();
    }

    IBTimestamp(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year_ = n;
        this.month_ = n2;
        this.date_ = n3;
        this.hour_ = n4;
        this.minute_ = n5;
        this.second_ = n6;
        this.encodeYearMonthDay();
        this.encodeHourMinuteSecond();
    }

    int getYear() {
        return this.year_;
    }

    int getMonth() {
        return this.month_;
    }

    int getDate() {
        return this.date_;
    }

    int getHours() {
        return this.hour_;
    }

    int getMinutes() {
        return this.minute_;
    }

    int getSeconds() {
        return this.second_;
    }

    int getNanos() {
        return 0;
    }

    private void encodeYearMonthDay() {
        int n = this.year_ + 1900;
        int n2 = this.month_ + 1;
        if (n2 > 2) {
            n2 -= 3;
        } else {
            n2 += 9;
            --n;
        }
        int n3 = n / 100;
        int n4 = n - 100 * n3;
        this.encodedYearMonthDay_ = 146097 * n3 / 4 + 1461 * n4 / 4 + (153 * n2 + 2) / 5 + this.date_ + 1721119 - 2400001;
    }

    private void encodeHourMinuteSecond() {
        int n = this.hour_ * 60 + this.minute_ - 0;
        this.encodedHourMinuteSecond_ = n * 60 * 10000 + this.second_ * 10000;
    }

    private void decodeYearMonthDay() {
        int n = this.encodedYearMonthDay_;
        this.year_ = (4 * (n -= -678882) - 1) / 146097;
        n = 4 * n - 1 - 146097 * this.year_;
        this.date_ = n / 4;
        n = (4 * this.date_ + 3) / 1461;
        this.date_ = 4 * this.date_ + 3 - 1461 * n;
        this.date_ = (this.date_ + 4) / 4;
        this.month_ = (5 * this.date_ - 3) / 153;
        this.date_ = 5 * this.date_ - 3 - 153 * this.month_;
        this.date_ = (this.date_ + 5) / 5;
        this.year_ = 100 * this.year_ + n;
        if (this.month_ < 10) {
            this.month_ += 3;
        } else {
            this.month_ -= 9;
            ++this.year_;
        }
        this.year_ -= 1900;
        --this.month_;
    }

    private void decodeHourMinuteSecond() {
        int n = this.encodedHourMinuteSecond_ / 600000 + 0;
        this.hour_ = n / 60;
        this.minute_ = n % 60;
        this.second_ = this.encodedHourMinuteSecond_ / 10000 % 60;
    }
}

