/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.CharacterEncodings;
import interbase.interclient.Connection;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.SQLDialectException;
import interbase.interclient.URLSyntaxException;
import interbase.interclient.Utils;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Driver
implements java.sql.Driver {
    boolean expiredDriver_ = false;
    private static SQLException exceptionsOnLoadDriver__ = null;
    public static final int testBuild = 0;
    public static final int betaBuild = 1;
    public static final int finalBuild = 2;

    public Driver() {
        Date date;
        if (Globals.interclientExpirationDate__ != null && (date = new Date()).after(Globals.interclientExpirationDate__)) {
            this.expiredDriver_ = true;
        }
    }

    public synchronized java.sql.Connection connect(String string, Properties properties) throws SQLException {
        int n;
        if (exceptionsOnLoadDriver__ != null) {
            throw exceptionsOnLoadDriver__;
        }
        StringTokenizer stringTokenizer = this.tokenizeInterBaseProtocol(string);
        if (stringTokenizer == null) {
            return null;
        }
        String string2 = this.tokenizeServerNameAndPort(stringTokenizer, string);
        int n2 = string2.indexOf(58);
        String string3 = n2 == -1 ? string2 : string2.substring(0, n2);
        int n3 = n2 == -1 ? 3060 : Integer.parseInt(string2.substring(n2 + 1));
        String string4 = this.tokenizeDatabase(stringTokenizer, string);
        if (properties == null || properties.getProperty("user") == null || properties.getProperty("password") == null || properties.getProperty("user").equals("") || properties.getProperty("password").equals("")) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__connection_properties__no_user_or_password__);
        }
        String string5 = properties.getProperty("sqlDialect");
        try {
            if (string5 != null && (n = Integer.parseInt(string5)) < 0) {
                throw new SQLDialectException(ErrorKey.invalidArgument__connection_properties__sql_dialect__, string5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLDialectException(ErrorKey.invalidArgument__connection_properties__sql_dialect__, string5);
        }
        n = DriverManager.getLoginTimeout() * 1000;
        Connection connection = new Connection(n, string3, n3, string4, properties);
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return this.tokenizeInterBaseProtocol(string) != null;
    }

    public synchronized DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[8];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfoArray[0] = new DriverPropertyInfo("user", properties.getProperty("user"));
        driverPropertyInfoArray[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfoArray[2] = new DriverPropertyInfo("charSet", properties.getProperty("charSet", "NONE"));
        driverPropertyInfoArray[3] = new DriverPropertyInfo("roleName", properties.getProperty("roleName"));
        driverPropertyInfoArray[5] = new DriverPropertyInfo("sweepOnConnect", properties.getProperty("sweepOnConnect", "false"));
        driverPropertyInfoArray[6] = new DriverPropertyInfo("suggestedCachePages", properties.getProperty("suggestedCachePages"));
        driverPropertyInfoArray[7] = new DriverPropertyInfo("sqlDialect", properties.getProperty("sqlDialect"));
        driverPropertyInfoArray[0].description = Globals.getResource("107");
        driverPropertyInfoArray[1].description = Globals.getResource("108");
        driverPropertyInfoArray[2].description = Globals.getResource("109");
        driverPropertyInfoArray[3].description = Globals.getResource("110");
        driverPropertyInfoArray[5].description = Globals.getResource("112");
        driverPropertyInfoArray[6].description = Globals.getResource("114");
        driverPropertyInfoArray[7].description = Globals.getResource("128");
        driverPropertyInfoArray[0].required = true;
        driverPropertyInfoArray[1].required = true;
        driverPropertyInfoArray[2].required = false;
        driverPropertyInfoArray[3].required = false;
        driverPropertyInfoArray[4].required = false;
        driverPropertyInfoArray[5].required = false;
        driverPropertyInfoArray[6].required = false;
        driverPropertyInfoArray[7].required = false;
        driverPropertyInfoArray[2].choices = CharacterEncodings.getSupportedEncodings();
        driverPropertyInfoArray[5].choices = new String[]{"false", "true"};
        driverPropertyInfoArray[7].choices = new String[]{"1", "2", "3"};
        return driverPropertyInfoArray;
    }

    private StringTokenizer tokenizeInterBaseProtocol(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/ \t\n\r", true);
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals("jdbc:interbase:")) {
            return null;
        }
        return stringTokenizer;
    }

    private String tokenizeServerNameAndPort(StringTokenizer stringTokenizer, String string) throws SQLException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_prefix_0__, string);
        }
        if (!stringTokenizer.nextToken().equals("/")) {
            throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_prefix_0__, string);
        }
        if (!stringTokenizer.nextToken().equals("/")) {
            throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_prefix_0__, string);
        }
        try {
            return stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_prefix_0__, string);
        }
    }

    private String tokenizeDatabase(StringTokenizer stringTokenizer, String string) throws SQLException {
        try {
            if (!stringTokenizer.nextToken().equals("/")) {
                throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_suffix_0__, string);
            }
            return stringTokenizer.nextToken("\t\n\r");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_suffix_0__, string);
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public int getBuildNumber() {
        return 1;
    }

    public int getBuildCertificationLevel() {
        return 0;
    }

    public boolean clientServerEdition() {
        return true;
    }

    public boolean expiredDriver() {
        return this.expiredDriver_;
    }

    public String getCompanyName() {
        return Globals.getResource("97");
    }

    public String[] getCompatibleJREVersions() {
        return Globals.interclientCompatibleJREVersions__;
    }

    public int[] getCompatibleIBVersions() {
        return Globals.compatibleIBVersions__;
    }

    public Date getExpirationDate() {
        return Globals.interclientExpirationDate__;
    }

    public String getJDBCNetProtocol() {
        return "jdbc:interbase:";
    }

    public int getJDBCNetProtocolVersion() {
        return 20001;
    }

    static {
        Utils.accumulateSQLExceptions(exceptionsOnLoadDriver__, Globals.exceptionsOnLoadResources__);
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            Utils.accumulateSQLExceptions(exceptionsOnLoadDriver__, sQLException);
        }
    }
}

