/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BugCheckException;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBTimestamp;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.MessageBufferOutputStream;
import interbase.interclient.ParameterConversionException;
import interbase.interclient.RecvMessage;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;

public final class Array
implements java.sql.Array {
    Object data_ = null;
    int[] id_ = new int[]{0, 0};
    ArrayDescriptor descriptor_ = null;
    Connection connection_ = null;
    private static final BigDecimal bdMaxShortValue = new BigDecimal(32767.0);
    private static final BigDecimal bdMinShortValue = new BigDecimal(-32768.0);
    private static final BigDecimal bdMaxIntValue = new BigDecimal(2.147483647E9);
    private static final BigDecimal bdMinIntValue = new BigDecimal(-2.147483648E9);
    private static final BigDecimal bdMaxFloatValue = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue = new BigDecimal(1.4E-45f);
    private static final BigDecimal bdMaxDoubleValue = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue = new BigDecimal(Double.MIN_VALUE);
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Timestamp;

    Array(Object object) throws SQLException {
        if (!object.getClass().isArray()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 131);
        }
        this.data_ = object;
    }

    Array(Object object, ArrayDescriptor arrayDescriptor) throws SQLException {
        if (!object.getClass().isArray()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 132);
        }
        this.setDescriptor(arrayDescriptor);
        this.data_ = object;
    }

    Array(int[] nArray, ArrayDescriptor arrayDescriptor, Connection connection) throws SQLException {
        this.setDescriptor(arrayDescriptor);
        this.id_[0] = nArray[0];
        this.id_[1] = nArray[1];
        this.connection_ = connection;
    }

    void setDescriptor(ArrayDescriptor arrayDescriptor) throws SQLException {
        if (arrayDescriptor == null) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 133);
        }
        if (this.data_ != null) {
            this.checkDimensions(this.data_, arrayDescriptor, 0);
        }
        this.descriptor_ = arrayDescriptor;
    }

    private void checkDimensions(Object object, ArrayDescriptor arrayDescriptor, int n) throws SQLException {
        if (object == null) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
        int n2 = java.lang.reflect.Array.getLength(object);
        if (arrayDescriptor.dimensionBounds_[n][1] - arrayDescriptor.dimensionBounds_[n][0] + 1 != n2) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
        if (object.getClass().getComponentType().isArray()) {
            if (++n >= arrayDescriptor.dimensions_) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
            }
            int n3 = 0;
            while (n3 < n2) {
                this.checkDimensions(java.lang.reflect.Array.get(object, n3), arrayDescriptor, n);
                ++n3;
            }
        } else if (n != arrayDescriptor.dimensions_ - 1) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
    }

    void send(MessageBufferOutputStream messageBufferOutputStream) throws SQLException {
        messageBufferOutputStream.writeArrayId(this.id_);
        this.descriptor_.send(messageBufferOutputStream, this.descriptor_.dimensionBounds_);
        this.send_Data(messageBufferOutputStream, this.data_);
    }

    private void send_Data(MessageBufferOutputStream messageBufferOutputStream, Object object) throws SQLException {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isArray()) {
            int n = 0;
            while (n < ((Object[])object).length) {
                this.send_Data(messageBufferOutputStream, ((Object[])object)[n]);
                ++n;
            }
        } else {
            switch (this.descriptor_.elementDataType_) {
                case 1: {
                    this.send_SMALLINT(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 2: {
                    this.send_INTEGER(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 3: {
                    this.send_FLOAT(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 4: {
                    this.send_DOUBLE(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 6: 
                case 7: {
                    this.send_NUMERIC_INTEGER(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 5: {
                    this.send_NUMERIC_DOUBLE(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 8: 
                case 9: {
                    this.send_CHAR(messageBufferOutputStream, object, clazz);
                    break;
                }
                case 11: {
                    this.send_DATE(messageBufferOutputStream, object, clazz);
                    break;
                }
                default: {
                    throw new BugCheckException(ErrorKey.bugCheck__0__, 138);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void send_SMALLINT(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz.equals(Short.TYPE)) {
                int n2 = 0;
                while (n2 < n) {
                    messageBufferOutputStream.writeShort(((short[])object)[n2]);
                    ++n2;
                }
                return;
            } else if (clazz.equals(Byte.TYPE)) {
                int n3 = 0;
                while (n3 < n) {
                    messageBufferOutputStream.writeShort(((byte[])object)[n3]);
                    ++n3;
                }
                return;
            } else if (clazz.equals(Integer.TYPE)) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = ((int[])object)[n4];
                    if (n5 > Short.MAX_VALUE || n5 < Short.MIN_VALUE) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(n5));
                    }
                    messageBufferOutputStream.writeShort((short)n5);
                    ++n4;
                }
                return;
            } else if (clazz.equals(Long.TYPE)) {
                int n6 = 0;
                while (n6 < n) {
                    long l = ((long[])object)[n6];
                    if (l > 32767L || l < -32768L) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(l));
                    }
                    messageBufferOutputStream.writeShort((short)l);
                    ++n6;
                }
                return;
            } else if (clazz.equals(Float.TYPE)) {
                int n7 = 0;
                while (n7 < n) {
                    float f = ((float[])object)[n7];
                    if (f > 32767.0f || f < -32768.0f) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(f));
                    }
                    messageBufferOutputStream.writeShort((short)f);
                    ++n7;
                }
                return;
            } else if (clazz.equals(Double.TYPE)) {
                int n8 = 0;
                while (n8 < n) {
                    double d = ((double[])object)[n8];
                    if (d > 32767.0 || d < -32768.0) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(d));
                    }
                    messageBufferOutputStream.writeShort((short)d);
                    ++n8;
                }
                return;
            } else {
                if (!clazz.equals(Boolean.TYPE)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                int n9 = 0;
                while (n9 < n) {
                    messageBufferOutputStream.writeShort(((boolean[])object)[n9] ? 1 : 0);
                    ++n9;
                }
            }
            return;
        } else {
            int n10 = 0;
            while (n10 < n) {
                short s;
                Object object2 = ((Object[])object)[n10];
                if (object2 instanceof Short) {
                    s = (Short)object2;
                } else if (object2 instanceof Byte) {
                    s = ((Byte)object2).shortValue();
                } else if (object2 instanceof Integer) {
                    s = ((Integer)object2).shortValue();
                } else if (object2 instanceof Long) {
                    long l = (Long)object2;
                    if (l > 32767L || l < -32768L) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(l));
                    }
                    s = ((Long)object2).shortValue();
                } else if (object2 instanceof Float) {
                    float f = ((Float)object2).floatValue();
                    if (f > 32767.0f || f < -32768.0f) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(f));
                    }
                    s = ((Float)object2).shortValue();
                } else if (object2 instanceof Double) {
                    double d = (Double)object2;
                    if (d > 32767.0 || d < -32768.0) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(d));
                    }
                    s = ((Double)object2).shortValue();
                } else if (object2 instanceof BigDecimal) {
                    if (((BigDecimal)object2).compareTo(bdMaxShortValue) == 1 || ((BigDecimal)object2).compareTo(bdMinShortValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(object2));
                    }
                    s = ((BigDecimal)object2).shortValue();
                } else if (object2 instanceof String) {
                    try {
                        s = Short.parseShort((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                    }
                } else {
                    if (!(object2 instanceof Boolean)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                    s = (Boolean)object2 != false ? (short)1 : 0;
                }
                messageBufferOutputStream.writeShort(s);
                ++n10;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void send_INTEGER(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz.equals(Integer.TYPE)) {
                int n2 = 0;
                while (n2 < n) {
                    messageBufferOutputStream.writeInt(((int[])object)[n2]);
                    ++n2;
                }
                return;
            } else if (clazz.equals(Byte.TYPE)) {
                int n3 = 0;
                while (n3 < n) {
                    messageBufferOutputStream.writeInt(((byte[])object)[n3]);
                    ++n3;
                }
                return;
            } else if (clazz.equals(Short.TYPE)) {
                int n4 = 0;
                while (n4 < n) {
                    messageBufferOutputStream.writeInt(((short[])object)[n4]);
                    ++n4;
                }
                return;
            } else if (clazz.equals(Long.TYPE)) {
                int n5 = 0;
                while (n5 < n) {
                    long l = ((long[])object)[n5];
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(l));
                    }
                    messageBufferOutputStream.writeInt((int)l);
                    ++n5;
                }
                return;
            } else if (clazz.equals(Float.TYPE)) {
                int n6 = 0;
                while (n6 < n) {
                    float f = ((float[])object)[n6];
                    if (f > 2.1474836E9f || f < -2.1474836E9f) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(f));
                    }
                    messageBufferOutputStream.writeInt((int)f);
                    ++n6;
                }
                return;
            } else if (clazz.equals(Double.TYPE)) {
                int n7 = 0;
                while (n7 < n) {
                    double d = ((double[])object)[n7];
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(d));
                    }
                    messageBufferOutputStream.writeInt((int)d);
                    ++n7;
                }
                return;
            } else {
                if (!clazz.equals(Boolean.TYPE)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                int n8 = 0;
                while (n8 < n) {
                    messageBufferOutputStream.writeInt(((boolean[])object)[n8] ? 1 : 0);
                    ++n8;
                }
            }
            return;
        } else {
            int n9 = 0;
            while (n9 < n) {
                int n10;
                Object object2 = ((Object[])object)[n9];
                if (object2 instanceof Integer) {
                    n10 = (Integer)object2;
                } else if (object2 instanceof Byte) {
                    n10 = ((Byte)object2).intValue();
                } else if (object2 instanceof Short) {
                    n10 = ((Short)object2).intValue();
                } else if (object2 instanceof Long) {
                    long l = (Long)object2;
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(l));
                    }
                    n10 = ((Long)object2).intValue();
                } else if (object2 instanceof Float) {
                    float f = ((Float)object2).floatValue();
                    if (f > 2.1474836E9f || f < -2.1474836E9f) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(f));
                    }
                    n10 = ((Float)object2).intValue();
                } else if (object2 instanceof Double) {
                    double d = (Double)object2;
                    if (d > 2.147483647E9 || d < -2.147483648E9) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(d));
                    }
                    n10 = ((Double)object2).intValue();
                } else if (object2 instanceof BigDecimal) {
                    if (((BigDecimal)object2).compareTo(bdMaxIntValue) == 1 || ((BigDecimal)object2).compareTo(bdMinIntValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(object2));
                    }
                    n10 = ((BigDecimal)object2).intValue();
                } else if (object2 instanceof String) {
                    try {
                        n10 = Integer.parseInt((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                    }
                } else {
                    if (!(object2 instanceof Boolean)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                    n10 = (Boolean)object2 != false ? 1 : 0;
                }
                messageBufferOutputStream.writeInt(n10);
                ++n9;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void send_FLOAT(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz.equals(Float.TYPE)) {
                int n2 = 0;
                while (n2 < n) {
                    messageBufferOutputStream.writeFloat(((float[])object)[n2]);
                    ++n2;
                }
                return;
            } else if (clazz.equals(Byte.TYPE)) {
                int n3 = 0;
                while (n3 < n) {
                    messageBufferOutputStream.writeFloat(((byte[])object)[n3]);
                    ++n3;
                }
                return;
            } else if (clazz.equals(Short.TYPE)) {
                int n4 = 0;
                while (n4 < n) {
                    messageBufferOutputStream.writeFloat(((short[])object)[n4]);
                    ++n4;
                }
                return;
            } else if (clazz.equals(Integer.TYPE)) {
                int n5 = 0;
                while (n5 < n) {
                    messageBufferOutputStream.writeFloat(((int[])object)[n5]);
                    ++n5;
                }
                return;
            } else if (clazz.equals(Long.TYPE)) {
                int n6 = 0;
                while (n6 < n) {
                    messageBufferOutputStream.writeFloat(((long[])object)[n6]);
                    ++n6;
                }
                return;
            } else if (clazz.equals(Double.TYPE)) {
                int n7 = 0;
                while (n7 < n) {
                    double d = ((double[])object)[n7];
                    if (d > 3.4028234663852886E38 || d < (double)1.4E-45f) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(d));
                    }
                    messageBufferOutputStream.writeFloat((float)d);
                    ++n7;
                }
                return;
            } else {
                if (!clazz.equals(Boolean.TYPE)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                int n8 = 0;
                while (n8 < n) {
                    messageBufferOutputStream.writeFloat(((boolean[])object)[n8] ? 1.0f : 0.0f);
                    ++n8;
                }
            }
            return;
        } else {
            int n9 = 0;
            while (n9 < n) {
                float f;
                Object object2 = ((Object[])object)[n9];
                if (object2 instanceof Float) {
                    f = ((Float)object2).floatValue();
                } else if (object2 instanceof Byte) {
                    f = ((Byte)object2).floatValue();
                } else if (object2 instanceof Short) {
                    f = ((Short)object2).floatValue();
                } else if (object2 instanceof Integer) {
                    f = ((Integer)object2).floatValue();
                } else if (object2 instanceof Long) {
                    f = ((Long)object2).floatValue();
                } else if (object2 instanceof Double) {
                    double d = (Double)object2;
                    if (d > 3.4028234663852886E38 || d < (double)1.4E-45f) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(d));
                    }
                    f = ((Double)object2).floatValue();
                } else if (object2 instanceof BigDecimal) {
                    if (((BigDecimal)object2).compareTo(bdMaxFloatValue) == 1 || ((BigDecimal)object2).compareTo(bdMinFloatValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(object2));
                    }
                    f = ((BigDecimal)object2).floatValue();
                } else if (object2 instanceof String) {
                    try {
                        f = Float.valueOf((String)object2).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                    }
                } else {
                    if (!(object2 instanceof Boolean)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                    f = (Boolean)object2 != false ? 1.0f : 0.0f;
                }
                messageBufferOutputStream.writeFloat(f);
                ++n9;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void send_DOUBLE(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz.equals(Double.TYPE)) {
                int n2 = 0;
                while (n2 < n) {
                    messageBufferOutputStream.writeDouble(((double[])object)[n2]);
                    ++n2;
                }
                return;
            } else if (clazz.equals(Byte.TYPE)) {
                int n3 = 0;
                while (n3 < n) {
                    messageBufferOutputStream.writeDouble(((byte[])object)[n3]);
                    ++n3;
                }
                return;
            } else if (clazz.equals(Short.TYPE)) {
                int n4 = 0;
                while (n4 < n) {
                    messageBufferOutputStream.writeDouble(((short[])object)[n4]);
                    ++n4;
                }
                return;
            } else if (clazz.equals(Integer.TYPE)) {
                int n5 = 0;
                while (n5 < n) {
                    messageBufferOutputStream.writeDouble(((int[])object)[n5]);
                    ++n5;
                }
                return;
            } else if (clazz.equals(Long.TYPE)) {
                int n6 = 0;
                while (n6 < n) {
                    messageBufferOutputStream.writeDouble(((long[])object)[n6]);
                    ++n6;
                }
                return;
            } else if (clazz.equals(Float.TYPE)) {
                int n7 = 0;
                while (n7 < n) {
                    messageBufferOutputStream.writeDouble(((float[])object)[n7]);
                    ++n7;
                }
                return;
            } else {
                if (!clazz.equals(Boolean.TYPE)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                int n8 = 0;
                while (n8 < n) {
                    messageBufferOutputStream.writeDouble(((boolean[])object)[n8] ? 1.0 : 0.0);
                    ++n8;
                }
            }
            return;
        } else {
            int n9 = 0;
            while (n9 < n) {
                double d;
                Object object2 = ((Object[])object)[n9];
                if (object2 instanceof Double) {
                    d = (Double)object2;
                } else if (object2 instanceof Byte) {
                    d = ((Byte)object2).doubleValue();
                } else if (object2 instanceof Short) {
                    d = ((Short)object2).doubleValue();
                } else if (object2 instanceof Integer) {
                    d = ((Integer)object2).doubleValue();
                } else if (object2 instanceof Long) {
                    d = ((Long)object2).doubleValue();
                } else if (object2 instanceof Float) {
                    d = ((Float)object2).doubleValue();
                } else if (object2 instanceof BigDecimal) {
                    if (((BigDecimal)object2).compareTo(bdMaxDoubleValue) == 1 || ((BigDecimal)object2).compareTo(bdMinDoubleValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(object2));
                    }
                    d = ((BigDecimal)object2).doubleValue();
                } else if (object2 instanceof String) {
                    try {
                        d = Double.valueOf((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                    }
                } else {
                    if (!(object2 instanceof Boolean)) throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                    d = (Boolean)object2 != false ? 1.0 : 0.0;
                }
                messageBufferOutputStream.writeDouble(d);
                ++n9;
            }
        }
    }

    private void send_NUMERIC_INTEGER(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        BigDecimal bigDecimal = null;
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            int n2 = 0;
            while (n2 < n) {
                if (clazz.equals(Short.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Double.TYPE) || clazz.equals(Byte.TYPE)) {
                    bigDecimal = new BigDecimal(java.lang.reflect.Array.getDouble(object, n2));
                } else if (clazz.equals(Boolean.TYPE)) {
                    bigDecimal = new BigDecimal(((boolean[])object)[n2] ? 1.0 : 0.0);
                } else {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                }
                bigDecimal = bigDecimal.movePointRight(this.descriptor_.elementScale_);
                bigDecimal = bigDecimal.setScale(0, 5);
                if (this.descriptor_.elementDataType_ == 7) {
                    if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(bigDecimal.doubleValue()));
                    }
                    messageBufferOutputStream.writeShort(bigDecimal.shortValue());
                } else {
                    if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(bigDecimal.doubleValue()));
                    }
                    messageBufferOutputStream.writeInt(bigDecimal.intValue());
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                Object object2 = ((Object[])object)[n3];
                if (object2 instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)object2;
                } else if (object2 instanceof Number) {
                    bigDecimal = new BigDecimal(((Number)object2).doubleValue());
                } else if (object2 instanceof String) {
                    try {
                        bigDecimal = new BigDecimal((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                    }
                } else if (object2 instanceof Boolean) {
                    bigDecimal = new BigDecimal((Boolean)object2 != false ? 1.0 : 0.0);
                } else {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                }
                bigDecimal = bigDecimal.movePointRight(this.descriptor_.elementScale_);
                bigDecimal = bigDecimal.setScale(0, 5);
                if (this.descriptor_.elementDataType_ == 7) {
                    if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(bigDecimal.doubleValue()));
                    }
                    messageBufferOutputStream.writeShort(bigDecimal.shortValue());
                } else {
                    if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(bigDecimal.doubleValue()));
                    }
                    messageBufferOutputStream.writeInt(bigDecimal.intValue());
                }
                ++n3;
            }
        }
    }

    private void send_NUMERIC_DOUBLE(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            int n2 = 0;
            while (n2 < n) {
                double d;
                if (clazz.equals(Double.TYPE) || clazz.equals(Float.TYPE) || clazz.equals(Long.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE)) {
                    d = java.lang.reflect.Array.getDouble(object, n2);
                } else if (clazz.equals(Boolean.TYPE)) {
                    d = ((boolean[])object)[n2] ? 1.0 : 0.0;
                } else {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                }
                messageBufferOutputStream.writeDouble(d);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                double d;
                Object object2 = ((Object[])object)[n3];
                if (object2 instanceof BigDecimal) {
                    if (((BigDecimal)object2).compareTo(bdMaxDoubleValue) == 1 || ((BigDecimal)object2).compareTo(bdMinDoubleValue) == -1) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)String.valueOf(object2));
                    }
                    d = ((BigDecimal)object2).doubleValue();
                } else if (object2 instanceof Number) {
                    d = ((Number)object2).doubleValue();
                } else if (object2 instanceof String) {
                    try {
                        d = new BigDecimal((String)object2).doubleValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                    }
                } else if (object2 instanceof Boolean) {
                    d = (Boolean)object2 != false ? 1.0 : 0.0;
                } else {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                }
                messageBufferOutputStream.writeDouble(d);
                ++n3;
            }
        }
    }

    private void send_DATE(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
        }
        int n2 = 0;
        while (n2 < n) {
            IBTimestamp iBTimestamp;
            Object object2 = ((Object[])object)[n2];
            if (object2 instanceof Date) {
                iBTimestamp = new IBTimestamp(((Date)object2).getYear(), ((Date)object2).getMonth(), ((Date)object2).getDate());
            } else if (object2 instanceof Timestamp) {
                iBTimestamp = new IBTimestamp(((Timestamp)object2).getYear(), ((Timestamp)object2).getMonth(), ((Timestamp)object2).getDate(), ((Timestamp)object2).getHours(), ((Timestamp)object2).getMinutes(), ((Timestamp)object2).getSeconds());
            } else if (object2 instanceof String) {
                try {
                    Timestamp timestamp = Timestamp.valueOf((String)object2);
                    iBTimestamp = new IBTimestamp(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate(), timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_conversion_0__, (Object)((String)object2));
                }
            } else {
                throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
            }
            messageBufferOutputStream.writeInt(iBTimestamp.encodedYearMonthDay_);
            messageBufferOutputStream.writeInt(iBTimestamp.encodedHourMinuteSecond_);
            ++n2;
        }
    }

    private void send_CHAR(MessageBufferOutputStream messageBufferOutputStream, Object object, Class clazz) throws SQLException {
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isPrimitive()) {
            int n2 = 0;
            while (n2 < n) {
                String string;
                if (clazz.equals(Double.TYPE) || clazz.equals(Float.TYPE)) {
                    string = String.valueOf(java.lang.reflect.Array.getDouble(object, n2));
                } else if (clazz.equals(Long.TYPE) || clazz.equals(Integer.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Byte.TYPE)) {
                    string = String.valueOf(java.lang.reflect.Array.getLong(object, n2));
                } else if (clazz.equals(Boolean.TYPE)) {
                    string = String.valueOf(((boolean[])object)[n2]);
                } else {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                }
                if (string.length() > this.descriptor_.elementPrecision_) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_truncation_0__, (Object)string);
                }
                messageBufferOutputStream.writeLDSQLText(string);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                String string;
                Object object2 = ((Object[])object)[n3];
                if (object2 instanceof String) {
                    string = (String)object2;
                } else if (object2 instanceof Byte || object2 instanceof Short || object2 instanceof Integer || object2 instanceof Long || object2 instanceof Float || object2 instanceof Double || object2 instanceof BigDecimal || object2 instanceof Date || object2 instanceof Timestamp || object2 instanceof Boolean) {
                    string = object2.toString();
                } else {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_type_conversion__);
                }
                if (string.length() > this.descriptor_.elementPrecision_) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__array_element_instance_truncation_0__, (Object)string);
                }
                messageBufferOutputStream.writeLDSQLText(string);
                ++n3;
            }
        }
    }

    private Object remote_GET_ARRAY_SLICE(int[][] nArray) throws SQLException {
        this.connection_.checkForClosedConnection();
        this.connection_.clearWarnings();
        MessageBufferOutputStream messageBufferOutputStream = this.connection_.jdbcNet_.createMessage();
        messageBufferOutputStream.writeByte(39);
        this.connection_.send_TransactionConfigData(messageBufferOutputStream);
        messageBufferOutputStream.writeArrayId(this.id_);
        this.descriptor_.send(messageBufferOutputStream, nArray);
        Object object = this.createJavaArray(nArray);
        RecvMessage recvMessage = null;
        try {
            recvMessage = this.connection_.jdbcNet_.sendAndReceiveMessage(messageBufferOutputStream);
            if (!recvMessage.get_SUCCESS()) {
                throw recvMessage.get_EXCEPTIONS();
            }
            this.recv_Data(recvMessage, object);
            this.connection_.setWarning(recvMessage.get_WARNINGS());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.connection_.jdbcNet_.destroyRecvMessage(recvMessage);
            throw throwable;
        }
        this.connection_.jdbcNet_.destroyRecvMessage(recvMessage);
        return object;
    }

    private Object createJavaArray(int[][] nArray) throws SQLException {
        Class clazz = null;
        int[] nArray2 = new int[this.descriptor_.dimensions_];
        int n = 0;
        while (n < this.descriptor_.dimensions_) {
            nArray2[n] = nArray[n][1] - nArray[n][0] + 1;
            ++n;
        }
        switch (this.descriptor_.elementDataType_) {
            case 1: {
                clazz = Short.TYPE;
                break;
            }
            case 2: {
                clazz = Integer.TYPE;
                break;
            }
            case 3: {
                clazz = Float.TYPE;
                break;
            }
            case 4: {
                clazz = Double.TYPE;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                clazz = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Array.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                break;
            }
            case 8: 
            case 9: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = Array.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 11: {
                clazz = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Array.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
                break;
            }
            default: {
                throw new BugCheckException(ErrorKey.bugCheck__0__, 135);
            }
        }
        return java.lang.reflect.Array.newInstance(clazz, nArray2);
    }

    private void recv_Data(RecvMessage recvMessage, Object object) throws SQLException {
        Class<?> clazz = object.getClass().getComponentType();
        int n = java.lang.reflect.Array.getLength(object);
        if (clazz.isArray()) {
            int n2 = 0;
            while (n2 < n) {
                this.recv_Data(recvMessage, ((Object[])object)[n2]);
                ++n2;
            }
            return;
        }
        switch (this.descriptor_.elementDataType_) {
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    ((short[])object)[n3] = recvMessage.readShort();
                    ++n3;
                }
                return;
            }
            case 2: {
                int n4 = 0;
                while (n4 < n) {
                    ((int[])object)[n4] = recvMessage.readInt();
                    ++n4;
                }
                return;
            }
            case 3: {
                int n5 = 0;
                while (n5 < n) {
                    ((float[])object)[n5] = recvMessage.readFloat();
                    ++n5;
                }
                return;
            }
            case 4: {
                int n6 = 0;
                while (n6 < n) {
                    ((double[])object)[n6] = recvMessage.readDouble();
                    ++n6;
                }
                return;
            }
            case 7: {
                int n7 = 0;
                while (n7 < n) {
                    ((BigDecimal[])object)[n7] = BigDecimal.valueOf(recvMessage.readShort(), this.descriptor_.elementScale_);
                    ++n7;
                }
                return;
            }
            case 6: {
                int n8 = 0;
                while (n8 < n) {
                    ((BigDecimal[])object)[n8] = BigDecimal.valueOf(recvMessage.readInt(), this.descriptor_.elementScale_);
                    ++n8;
                }
                return;
            }
            case 5: {
                int n9 = 0;
                while (n9 < n) {
                    ((BigDecimal[])object)[n9] = new BigDecimal(recvMessage.readDouble()).setScale(this.descriptor_.elementScale_, 6);
                    ++n9;
                }
                return;
            }
            case 8: 
            case 9: {
                int n10 = 0;
                while (n10 < n) {
                    ((String[])object)[n10] = new String(recvMessage.readLDSQLText());
                    ++n10;
                }
                return;
            }
            case 11: {
                int n11 = 0;
                while (n11 < n) {
                    int[] nArray = recvMessage.readTimestampId();
                    IBTimestamp iBTimestamp = new IBTimestamp(2, nArray);
                    ((Timestamp[])object)[n11] = new Timestamp(iBTimestamp.getYear(), iBTimestamp.getMonth(), iBTimestamp.getDate(), iBTimestamp.getHours(), iBTimestamp.getMinutes(), iBTimestamp.getSeconds(), iBTimestamp.getNanos());
                    ++n11;
                }
                return;
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 136);
    }

    public synchronized String getBaseTypeName() throws SQLException {
        return IBTypes.getIBTypeName(this.descriptor_.elementDataType_);
    }

    public synchronized int getBaseType() throws SQLException {
        return IBTypes.getSQLType(this.descriptor_.elementDataType_);
    }

    public synchronized Object getArray() throws SQLException {
        if (this.data_ != null) {
            return this.data_;
        }
        this.connection_.transactionStartedOnClient_ = true;
        this.data_ = this.remote_GET_ARRAY_SLICE(this.descriptor_.dimensionBounds_);
        this.connection_.transactionStartedOnServer_ = true;
        return this.data_;
    }

    public synchronized Object getArray(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Object getArray(long l, int n) throws SQLException {
        int[][] nArray = this.descriptor_.getDimensions();
        nArray[0][0] = (int)l;
        nArray[0][1] = (int)(l + (long)n - 1L);
        boolean bl = this.descriptor_.checkSliceBounds(nArray);
        Object object = this.remote_GET_ARRAY_SLICE(nArray);
        if (bl) {
            this.data_ = object;
        }
        return object;
    }

    public synchronized Object getArray(long l, int n, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(long l, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Object getArray(int[][] nArray) throws SQLException {
        boolean bl = this.descriptor_.checkSliceBounds(nArray);
        Object object = this.remote_GET_ARRAY_SLICE(nArray);
        if (bl) {
            this.data_ = object;
        }
        return object;
    }

    public synchronized ResultSet getResultSet(int[][] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

