import java.util.*;

public class Transaction{
  private Date _date;
  private Vector _sellingList;
  private static SelectableVector $_transactionList = new SelectableVector();

  public Transaction( Date date ){
    _date = date;
    _sellingList = new Vector();
    $_transactionList.add(this);
  }

  public void addSelling( Selling selling ){
    if(selling != null){
      _sellingList.add( selling );
    }
  }
  
  public Collection getSellings(){
	return new Vector(_sellingList);
  }

  public Date getDate(){
    return _date;
  }

  public int sumSales(){
    int sales = 0;
    
    Iterator iter = _sellingList.iterator();
    while( iter.hasNext() ){
      sales += ((Selling)iter.next()).getSales();
    }
    return sales;
  }

  public String getSoldProductNames(){
    String retval="";

    if(_sellingList.size() == 0) return "";
    Iterator iter = _sellingList.iterator();
    while(iter.hasNext()){
      Selling selling = (Selling)iter.next();
      retval += selling.getProduct().getName() + "@" + selling.getQuantity() + "\n";
    }
    return retval;
  }

  static public Collection $select(Select condition)
  {
	return $_transactionList.select(condition);
  }

  public static int $getSize(){
    return $_transactionList.size();
  }
}